/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.sinytra.fabric.networking_api.server.NeoServerConfigurationNetworking;

public final class ServerConfigurationNetworking {
    public static <T extends CustomPacketPayload> boolean registerGlobalReceiver(CustomPacketPayload.Type<T> type, ConfigurationPacketHandler<T> handler) {
        return NeoServerConfigurationNetworking.registerGlobalReceiver(type, handler);
    }

    @Nullable
    public static ConfigurationPacketHandler<?> unregisterGlobalReceiver(ResourceLocation id) {
        return NeoServerConfigurationNetworking.unregisterGlobalReceiver(id);
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return NeoServerConfigurationNetworking.getGlobalReceivers();
    }

    public static <T extends CustomPacketPayload> boolean registerReceiver(ServerConfigurationPacketListenerImpl networkHandler, CustomPacketPayload.Type<T> type, ConfigurationPacketHandler<T> handler) {
        return NeoServerConfigurationNetworking.registerReceiver(networkHandler, type, handler);
    }

    @Nullable
    public static ConfigurationPacketHandler<?> unregisterReceiver(ServerConfigurationPacketListenerImpl networkHandler, ResourceLocation id) {
        return NeoServerConfigurationNetworking.unregisterReceiver(networkHandler, id);
    }

    public static Set<ResourceLocation> getReceived(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return NeoServerConfigurationNetworking.getReceived(handler);
    }

    public static Set<ResourceLocation> getSendable(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return NeoServerConfigurationNetworking.getSendable(handler);
    }

    public static boolean canSend(ServerConfigurationPacketListenerImpl handler, ResourceLocation channelName) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return NeoServerConfigurationNetworking.canSend(handler, channelName);
    }

    public static boolean canSend(ServerConfigurationPacketListenerImpl handler, CustomPacketPayload.Type<?> id) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(id, "Payload id cannot be null");
        return NeoServerConfigurationNetworking.canSend(handler, id.id());
    }

    public static Packet<ClientCommonPacketListener> createS2CPacket(CustomPacketPayload payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.type(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        return ServerNetworkingImpl.createS2CPacket(payload);
    }

    public static PacketSender getSender(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return NeoServerConfigurationNetworking.getSender(handler);
    }

    public static void send(ServerConfigurationPacketListenerImpl handler, CustomPacketPayload payload) {
        Objects.requireNonNull(handler, "Server configuration handler cannot be null");
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.type(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        handler.send(ServerConfigurationNetworking.createS2CPacket(payload));
    }

    public static MinecraftServer getServer(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerCommonNetworkHandlerAccessor)handler).getServer();
    }

    public static boolean isReconfiguring(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return NeoServerConfigurationNetworking.isReconfiguring(handler);
    }

    private ServerConfigurationNetworking() {
    }

    @FunctionalInterface
    public static interface ConfigurationPacketHandler<T extends CustomPacketPayload> {
        public void receive(T var1, Context var2);
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public MinecraftServer server();

        public ServerConfigurationPacketListenerImpl networkHandler();

        public PacketSender responseSender();
    }
}

